let csrfToken = null;
async function ensureMe(){
  const r = await fetch('/api/me', { credentials:'include' });
  const j = await r.json();
  csrfToken = j.csrfToken;
  if (!j.user){ location.href='/login'; return null; }
  return j.user;
}

const $ = (s,p=document)=>p.querySelector(s);
const fmt = (n)=> Number(n||0).toFixed(2);
const mask = (name)=> name && name.length>1 ? `${name[0]}...${name[name.length-1]}` : (name||'--');

// Refs
const canvas = $('#game');
const ctx = canvas.getContext('2d');
const multEl = $('#mult');
const walletBal = $('#walletBal');

const deposit1 = $('#deposit1');
const deposit2 = $('#deposit2');
const btnA = $('#btnA');
const btnB = $('#btnB');

const prevRound = $('#prevRound');
const youLine = $('#youLine');
const youInfo = $('#youInfo');
const playersWrap = $('#playersWrap');

const autoA = $('#autoA');
const autoB = $('#autoB');
const autoBetA = $('#autoBetA');
const autoBetB = $('#autoBetB');
const autoCashA = $('#autoCashA');
const autoCashB = $('#autoCashB');

const overlay = $('#overlay');
const countdownText = $('#countdownText');
function showOverlay(){ overlay.classList.remove('hidden'); }
function hideOverlay(){ overlay.classList.add('hidden'); }

function setupTabs(rootSel, autoWrapSel , autobetX){
  const root = $(rootSel).closest('.card');
  const tabs = root.querySelectorAll('.tabs .tab');
  const autoWrap = $(autoWrapSel);
  const autobet = $(autobetX);
  tabs.forEach(tab=>{
    tab.addEventListener('click', ()=>{
      tabs.forEach(t=>t.classList.remove('active'));
      tab.classList.add('active');
      if (tab.dataset.mode==='auto'){
        autoWrap.removeAttribute('hidden');
        autobet.checked = true;
    }else{autoWrap.setAttribute('hidden','');    
        autobet.checked = false;
        }
    });
  });
}
setupTabs('#betA','#autoA' , '#autoBetA');
setupTabs('#betB','#autoB' , '#autoBetB');

function setupAmountControls(containerSel, input){
  const cont = $(containerSel);
  cont.addEventListener('click', (e)=>{
    const b = e.target.closest('b'); if(b){ const d=b.dataset.delta; input.value = Math.max(1, Number(input.value)+(d==='+'?1:-1)); updateButtons(lastState); return; }
    const pill = e.target.closest('.pill'); if(pill && pill.dataset.q){ const v = pill.dataset.q; input.value = (Number(input.value)+Number(v)); updateButtons(lastState); }
  });
  input.addEventListener('input', ()=> updateButtons(lastState));
}
setupAmountControls('#betA', deposit1);
setupAmountControls('#betB', deposit2);

let me=null, socket=null, lastState=null, prevPhase=null;
let serverDrift=0, countdownTimer=null;
function startCountdown(s){
  clearInterval(countdownTimer); showOverlay();
  countdownTimer = setInterval(()=>{
    serverDrift = Date.now() - (s.serverTime || Date.now());
    const nowServer = Date.now() - serverDrift;
    const left = Math.max(0, (s.bettingEndsAt||nowServer) - nowServer);
    countdownText.textContent = (left/1000).toFixed(1)+'s';
    if (left<=0){ clearInterval(countdownTimer); countdownText.textContent='0.0s'; }
  }, 100);
}

function place(slot, amount){ if(amount>0) socket.emit('placeBet', { slot, amount:Number(amount) }); }
function cash(slot){ socket.emit('cashOut', { slot }); }

// Canvas + visuals
const WIDTH=600, HEIGHT=300; canvas.width=WIDTH; canvas.height=HEIGHT;
let worldX=-10, cameraX=0, cameraY=0; const MAX_SCREEN_X=500, trail=[]; const MAX_POINTS=8000; const ease=.12;
const COLOR_LINE = getComputedStyle(document.documentElement).getPropertyValue('--accent').trim() || '#ff2e2e';
const COLOR_FILL = getComputedStyle(document.documentElement).getPropertyValue('--accent2').trim() || '#ff684f';
const planeImg = new Image(); planeImg.src='aviator.png';
let showPlane=true, planeScreenX=0, planeScreenY=0;
let explosion={active:false,parts:[]};
function resetPlane(){ worldX=-10; cameraX=0; cameraY=0; trail.splice(0,trail.length); showPlane=true; explosion.active=false; explosion.parts=[]; }
function startExplosion(x,y){ explosion.active=true; explosion.parts=[]; const N=90; for(let i=0;i<N;i++){ const ang=Math.random()*Math.PI*2; const spd=2+Math.random()*4; const vx=Math.cos(ang)*spd, vy=Math.sin(ang)*spd-.5; explosion.parts.push({x,y,vx,vy,r:1.5+Math.random()*2,life:1,col:Math.random()<.5?COLOR_LINE:COLOR_FILL}); } showPlane=false; }
function drawExplosion(){ if(!explosion.active) return; let alive=0; for(const p of explosion.parts){ if(p.life<=0) continue; p.x+=p.vx; p.y+=p.vy; p.vx*=.985; p.vy+=.12; p.life-=.02; ctx.globalAlpha=Math.max(0,p.life); ctx.fillStyle=p.col; ctx.beginPath(); ctx.arc(p.x,p.y,p.r,0,Math.PI*2); ctx.fill(); ctx.globalAlpha=1; if(p.life>0) alive++; } if(!alive) explosion.active=false; }
function worldYfromX(x){ const m=Math.max(1,(lastState?.multiplier||1)); const base=Math.log(Math.max(1,x+10)); const y=HEIGHT-22-(base*18+(m-1)*6); return Math.max(30,Math.min(HEIGHT-20,y)); }
function drawGrid(){ ctx.save(); ctx.globalAlpha=.12; ctx.lineWidth=1; const stepX=40, stepY=40; const firstX=Math.floor(cameraX/stepX)*stepX; for(let gx=firstX; gx<=cameraX+WIDTH; gx+=stepX){ const sx=gx-cameraX; ctx.strokeStyle='#2a3a5b'; ctx.beginPath(); ctx.moveTo(sx,0); ctx.lineTo(sx,HEIGHT); ctx.stroke(); } const firstY=Math.floor(cameraY/stepY)*stepY; for(let gy=firstY; gy<=cameraY+HEIGHT; gy+=stepY){ const sy=gy-cameraY; ctx.strokeStyle='#22314e'; ctx.beginPath(); ctx.moveTo(0,sy); ctx.lineTo(WIDTH,sy); ctx.stroke(); } ctx.restore(); }
function drawTrail(){ if(trail.length<2) return; const leftWorld=cameraX-20, rightWorld=cameraX+WIDTH+20; const pts=[]; for(const p of trail){ if(p.x>=leftWorld && p.x<=rightWorld) pts.push({sx:p.x-cameraX, sy:p.y-cameraY}); } if(pts.length<2) return; ctx.save(); ctx.beginPath(); ctx.moveTo(pts[0].sx, HEIGHT); ctx.lineTo(pts[0].sx, pts[0].sy); for(let i=1;i<pts.length;i++) ctx.lineTo(pts[i].sx, pts[i].sy); ctx.lineTo(pts[pts.length-1].sx, HEIGHT); ctx.closePath(); const grad=ctx.createLinearGradient(0,28,0,HEIGHT); grad.addColorStop(0,COLOR_FILL); grad.addColorStop(1,'#a61a1a'); ctx.fillStyle=grad; ctx.globalAlpha=.9; ctx.fill(); ctx.restore(); ctx.lineWidth=3; ctx.strokeStyle=COLOR_LINE; ctx.beginPath(); ctx.moveTo(pts[0].sx, pts[0].sy-1); for(let i=1;i<pts.length;i++) ctx.lineTo(pts[i].sx, pts[i].sy-1); ctx.stroke(); }
function drawPlane(x,y){ if(!showPlane) return; if(!planeImg.complete) return; const s=76; ctx.save(); ctx.translate(x,y); ctx.drawImage(planeImg,-s/5,-s,s,s); ctx.restore(); planeScreenX=x; planeScreenY=y; }
function tick(){ const isFlying=lastState?.phase==='flying'; if(isFlying){ worldX+=1.5; } const y=worldYfromX(worldX); trail.push({x:worldX,y}); if(trail.length>8000) trail.splice(0,trail.length-8000); const desiredScreenX=Math.min(worldX,500); cameraX=worldX-desiredScreenX; const screenY=y-cameraY; const mt=60, mb=HEIGHT-60; let tcy=cameraY; if(screenY<mt) tcy=y-mt; else if(screenY>mb) tcy=y-mb; cameraY+=(tcy-cameraY)*.12; ctx.clearRect(0,0,WIDTH,HEIGHT); drawGrid(); drawTrail(); drawPlane(desiredScreenX,y-cameraY); drawExplosion(); requestAnimationFrame(tick); }
requestAnimationFrame(tick);

function setBtnCash(btn, amountUSD, mult){ btn.disabled=false; btn.classList.add('cash'); btn.textContent=`CASH OUT $${fmt(amountUSD)}`; }
function setBtnBet(btn, amt, currency='GHS'){ btn.disabled=false; btn.classList.remove('cash'); btn.textContent=`BET ${currency} ${fmt(amt)}`; }
function setBtnPlaced(btn, amt, currency='GHS'){ btn.disabled=true; btn.classList.remove('cash'); btn.textContent=`BET PLACED ${currency} ${fmt(amt)}`; }
function setBtnClosed(btn, text='BET CLOSED'){ btn.disabled=true; btn.classList.remove('cash'); btn.textContent=text; }

function updateButtons(s){ if(!s||!me) return; const m = s.players?.find(p=>p.uid===me.id) || {}; // A
  if (s.phase==='betting'){ if (m.betA) setBtnPlaced(btnA, m.betA); else setBtnBet(btnA, Number(deposit1.value||0)); } else if (s.phase==='flying'){ if (m.betA && !m.cashedAtA) setBtnCash(btnA, m.betA*s.multiplier, s.multiplier); else if (m.cashedAtA) setBtnClosed(btnA, `CASHED @ ${m.cashedAtA.toFixed(2)}×`); else setBtnClosed(btnA); } else { setBtnClosed(btnA,'CRASHED'); } // B
  if (s.phase==='betting'){ if (m.betB) setBtnPlaced(btnB, m.betB); else setBtnBet(btnB, Number(deposit2.value||0)); } else if (s.phase==='flying'){ if (m.betB && !m.cashedAtB) setBtnCash(btnB, m.betB*s.multiplier, s.multiplier); else if (m.cashedAtB) setBtnClosed(btnB, `CASHED @ ${m.cashedAtB.toFixed(2)}×`); else setBtnClosed(btnB); } else { setBtnClosed(btnB,'CRASHED'); } }

function handleAction(slot){ const s=lastState; if(!s) return; const m=s.players?.find(p=>p.uid===me?.id); if (s.phase==='betting'){ const already = slot==='A' ? !!m?.betA : !!m?.betB; if (already) return; const amt=Number(slot==='A'?deposit1.value:deposit2.value); if(amt>0) place(slot, amt); } else if (s.phase==='flying'){ const notCashed = slot==='A' ? (!!m?.betA && !m?.cashedAtA) : (!!m?.betB && !m?.cashedAtB); if (notCashed) cash(slot); } }
btnA.addEventListener('click', ()=> handleAction('A'));
btnB.addEventListener('click', ()=> handleAction('B'));

deposit1.addEventListener('input', ()=> updateButtons(lastState));
deposit2.addEventListener('input', ()=> updateButtons(lastState));

(async function init(){
  me = await ensureMe(); if(!me) return; walletBal.textContent = fmt(me.balance);
  const socketIO = io({ withCredentials:true }); socket = socketIO;

  socket.on('hello', d=>{ walletBal.textContent = fmt(d.balance); });
  socket.on('errorMsg', msg=>{ const old = prevRound.textContent; prevRound.textContent = msg; setTimeout(()=>{ if(prevRound.textContent===msg) prevRound.textContent = old; }, 1500); });
  socket.on('state', s=>{
    if (prevPhase !== s.phase){ if (s.phase==='betting'){ resetPlane(); startCountdown(s); showOverlay(); } if (s.phase==='flying'){ hideOverlay(); resetPlane(); } if (s.phase==='crashed'){ startExplosion(planeScreenX||80, planeScreenY||(HEIGHT-80)); } prevPhase = s.phase; }
    lastState=s; serverDrift = Date.now() - (s.serverTime||Date.now());
    multEl.textContent = `${s.multiplier.toFixed(2)}×`;

    const mine = s.players.find(p=>p.uid===me.id);
    if (mine){ walletBal.textContent = fmt(mine.balance); const bits=[]; if (mine.betA) bits.push(`BetA: $${fmt(mine.betA)}`); if (mine.cashedAtA) bits.push(`A @ ${mine.cashedAtA.toFixed(2)}× • $${fmt(mine.winA||0)}`); if (mine.betB) bits.push(`BetB: $${fmt(mine.betB)}`); if (mine.cashedAtB) bits.push(`B @ ${mine.cashedAtB.toFixed(2)}× • $${fmt(mine.winB||0)}`); youLine.toggleAttribute('hidden', bits.length===0); youInfo.textContent = bits.join(' • '); }

    const head = `<thead><tr><th>Player</th><th>Bet A</th><th>Cash A</th><th>Win A</th><th>Bet B</th><th>Cash B</th><th>Win B</th></tr></thead>`;
    const rows = s.players.map(p=>`<tr><td>${p.name}</td><td>${p.betA? '$'+fmt(p.betA):'-'}</td><td>${p.cashedAtA? (p.cashedAtA.toFixed(2)+'×'):'-'}</td><td>${p.winA? '$'+fmt(p.winA):'-'}</td><td>${p.betB? '$'+fmt(p.betB):'-'}</td><td>${p.cashedAtB? (p.cashedAtB.toFixed(2)+'×'):'-'}</td><td>${p.winB? '$'+fmt(p.winB):'-'}</td></tr>`).join('');
    playersWrap.innerHTML = `<table>${head}<tbody>${rows}</tbody></table>`;

    if (s.phase==='betting'){
      if (autoBetA.checked && !s.players.find(p=>p.uid===me.id)?.betA) place('A', Number(deposit1.value));
      if (autoBetB.checked && !s.players.find(p=>p.uid===me.id)?.betB) place('B', Number(deposit2.value));
      if (s.crashAt) prevRound.textContent = `Prev: ${s.crashAt.toFixed(2)}×`;
    }
    if (s.phase==='flying' && mine){ const tA=Number(autoCashA?.value||0), tB=Number(autoCashB?.value||0); if (mine.betA && !mine.cashedAtA && autoBetA.checked && tA>0 && s.multiplier>=tA) cash('A'); if (mine.betB && !mine.cashedAtB && autoBetB.checked && tB>0 && s.multiplier>=tB) cash('B'); }

    updateButtons(s);
  });
})();