const $ = s=>document.querySelector(s);
const fmt = n=>Number(n||0).toFixed(2);

async function getMe(){
  const r = await fetch('/api/me', {credentials:'include'});
  const j = await r.json();
  if (!j.user) location.href='/login';
  $('#walletBal').textContent = fmt(j.user.balance);
  return j;
}

let poller = null, lastPrepayId = null, lastTradeNo = null;

async function createOrder(){
  const amt = Number($('#amt').value);
  const currency = $('#cur').value;
  $('#msg').textContent = '';
  const me = await getMe();
  try{
    const r = await fetch('/api/pay/create', {
      method:'POST', credentials:'include',
      headers:{'Content-Type':'application/json','CSRF-Token': me.csrfToken},
      body: JSON.stringify({ amount: amt, currency })
    });
    const j = await r.json();
    if(!r.ok){ $('#msg').textContent = j.error||'Xato'; return; }

    $('#payBox').hidden = false;
    $('#qr').src = j.qrcodeLink;
    $('#qrContent').textContent = j.qrContent || '';
    $('#checkoutUrl').href = j.checkoutUrl || '#';
    $('#universalUrl').href = j.universalUrl || '#';
    $('#openApp').href = j.universalUrl || j.checkoutUrl || '#';

    lastPrepayId = j.prepayId; lastTradeNo = j.merchantTradeNo;
    $('#status').textContent = 'PENDING';

    $('#copy').onclick = async ()=>{
      try{ await navigator.clipboard.writeText(($('#qrContent').textContent||'').trim()); const old=$('#copy').textContent; $('#copy').textContent='Copied!'; setTimeout(()=>$('#copy').textContent=old,1200); }catch(e){ /* fallback */ }
    };

    startPolling();
  }catch(e){ $('#msg').textContent = 'Tarmoq xatosi'; }
}

async function checkStatus(){
  if(!lastPrepayId && !lastTradeNo) return;
  const u = new URLSearchParams();
  if (lastPrepayId) u.set('prepayId', lastPrepayId); else u.set('merchantTradeNo', lastTradeNo);
  const r = await fetch('/api/pay/status?'+u.toString(), {credentials:'include'});
  const j = await r.json(); if(!r.ok){ $('#msg').textContent = j.error||'Xato'; return; }
  $('#status').textContent = j.status;
  if (j.status === 'PAID'){
    clearInterval(poller); poller=null; await getMe(); $('#backGame').hidden=false; $('#backGame').onclick=()=> location.href='/';
  }
}

function startPolling(){ clearInterval(poller); poller = setInterval(checkStatus, 2000); }

window.addEventListener('DOMContentLoaded', ()=>{ getMe(); $('#create').addEventListener('click', createOrder); });